#include <ArduinoIoTCloud.h>
#include <Arduino_ConnectionHandler.h>

const char THING_ID[] = "*************************************";  // Arduino Cloud Thing ID

const char SSID[] = "*********";    // Network SSID (name)
const char PASS[] = "*********";  // Network password (use for WPA, or use as key for WEP)

void onRainChange();
void onHumidityChange();
void onTemperatureChange();
void onWaterLevelChange();
void onSchZ1Change();
void onSchZ2Change();
void onSchZ3Change();
void onSchZ4Change();
void onLEDChange();
void onZ1Change();
void onZ2Change();
void onZ3Change();
void onZ4Change();
void onWaterUsageChange();
void onWaterVolumeChange();

int rain;
float humidity;
CloudTemperature temperature;
float water_level;
CloudSchedule sch_z1;
CloudSchedule sch_z2;
CloudSchedule sch_z3;
CloudSchedule sch_z4;
int z1_time;
int z2_time;
int z3_time;
int z4_time;
bool LED;
bool z1;
bool z2;
bool z3;
bool z4;
float water_usage;
float water_volume;

void initProperties() {

  ArduinoCloud.addProperty(rain, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(humidity, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(temperature, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(water_level, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(sch_z1, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(sch_z2, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(sch_z3, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(sch_z4, READWRITE, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(z1, READWRITE, ON_CHANGE, onZ1Change);
  ArduinoCloud.addProperty(z2, READWRITE, ON_CHANGE, onZ2Change);
  ArduinoCloud.addProperty(z3, READWRITE, ON_CHANGE, onZ3Change);
  ArduinoCloud.addProperty(z4, READWRITE, ON_CHANGE, onZ4Change);
  ArduinoCloud.addProperty(z1_time, READ, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(z2_time, READ, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(z3_time, READ, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(z4_time, READ, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(water_usage, READ, ON_CHANGE, NULL);
  ArduinoCloud.addProperty(water_volume, READWRITE, ON_CHANGE, NULL);
}

WiFiConnectionHandler ArduinoIoTPreferredConnection(SSID, PASS);
